<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    exit;
}

require 'db.php';

// Get crash level, random_mode, win_percent from game_settings
$crash_level = 5; // Default value
$random_mode = 0;
$win_percent = 70;
$active_mode = 'crash';
$gs = $conn->query('SELECT crash_level, random_mode, win_percent, active_mode FROM game_settings WHERE id=1');
if ($gs && $row = $gs->fetch_assoc()) {
    $crash_level = (int)$row['crash_level'];
    $random_mode = (int)$row['random_mode'];
    $win_percent = (int)$row['win_percent'];
    $active_mode = $row['active_mode'];
}

$max_level = 8;
if ($active_mode === 'crash') {
    // Use the crash_level from database - no changes needed
    // $crash_level already set from database
} elseif ($active_mode === 'random') {
    $crash_level = mt_rand(1, $max_level - 1);
} elseif ($active_mode === 'win_percent') {
    $rand = mt_rand(1, 100);
    if ($rand <= $win_percent) {
        // Use the crash_level from database as the winning level
        $crash_level = $crash_level; // This is the level from database
    } else {
        $crash_level = mt_rand(1, $crash_level - 1); // Random level below the set crash_level
    }
}

$conn->close();

// Return as JSON
header('Content-Type: application/json');
echo json_encode(['crash_level' => $crash_level]);
?> 